unit Whmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, agsocket, agwhois;

type
  TWhoIsForm = class(TForm)
    Memo1: TMemo;
    Panel2: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    QueryEdit: TEdit;
    SendQueryButton: TSpeedButton;
    CancelButton: TSpeedButton;
    agWhoIs1: TagWhoIs;
    procedure agWhoIs1Cancel(Sender: TObject);
    procedure agWhoIs1Closed(Sender: TObject);
    procedure agWhoIs1Error(Sender: TObject; var Msg: OpenString);
    procedure agWhoIs1Open(Sender: TObject);
    procedure agWhoIs1RecvProgress(Sender: TObject; Progress: Longint);
    procedure SendQueryButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure agWhoIs1SendingQuery(Sender: TObject);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  WhoIsForm: TWhoIsForm;

implementation

{$R *.DFM}

procedure TWhoIsForm.agWhoIs1Cancel(Sender: TObject);
begin
  Panel2.Caption:='Operation has been canceled';
end;

procedure TWhoIsForm.agWhoIs1Closed(Sender: TObject);
begin
  Panel2.Caption:='Connection closed';
end;

procedure TWhoIsForm.agWhoIs1Error(Sender: TObject; var Msg: OpenString);
begin
  Panel2.Caption:=Msg;
end;

procedure TWhoIsForm.agWhoIs1Open(Sender: TObject);
begin
  Panel2.Caption:='Openning connection';
end;

procedure TWhoIsForm.agWhoIs1RecvProgress(Sender: TObject;
  Progress: Longint);
begin
  Panel2.Caption:=IntToStr(Progress)+' bytes received';
end;

procedure TWhoIsForm.EnableControls;
begin
  QueryEdit.Enabled:=true;
  SendQueryButton.Enabled:=true;
  CancelButton.Enabled:=false;
end;

procedure TWhoIsForm.DisableControls;
begin
  QueryEdit.Enabled:=false;
  SendQueryButton.Enabled:=false;
  CancelButton.Enabled:=true;
end;

procedure TWhoIsForm.SendQueryButtonClick(Sender: TObject);
begin
  agWhoIs1.Query:=QueryEdit.Text;
  Memo1.Clear;
  DisableControls;
  try
    agWhoIs1.Execute;
    Memo1.Lines.LoadFromStream(agWhoIs1.OutStream);
  finally
    EnableControls;
  end;
end;

procedure TWhoIsForm.CancelButtonClick(Sender: TObject);
begin
  agWhoIs1.Cancel;
end;

procedure TWhoIsForm.agWhoIs1SendingQuery(Sender: TObject);
begin
  Panel2.Caption:='Sending query';
end;

end.
